/**
 * Messenger Plus! Legacy Chatlog
 *
 * @(#)Main.java
 *
 *
 * @author XP1
 * @version 1.01 2010/10/02
 */

import java.util.*;
import java.util.regex.*;
import java.text.*;
import java.io.*;

public class Main
{
    private static final String STR_NEWLINE = String.format("%n"); // Different operating systems use different newline separators

    /**
     * Creates a new instance of <code>Main</code>.
     */
    public Main()
    {
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args)
    {
        // TODO code application logic here

        // Sample Messenger Plus! Legacy Chatlog
        /*
            .--------------------------------------------------------------------.
            | Session Start: 26 February 2004                                    |
            | Participants:                                                      |
            |    My user name (**********@hotmail.com)                           |
            |    Recipient's user name (*******@hotmail.com)                     |
            .--------------------------------------------------------------------.
            [16:44:33] My user name: Hello there
            [16:45:02] Recipient's : hi
            [16:45:49] My user name: How are you?
            [16:46:37] Recipient's : I'm ok
            [16:46:38] Recipient's : yourself?
        */

        final String STR_SAMPLE_CHATLOG = (".--------------------------------------------------------------------." + STR_NEWLINE +
                "| Session Start: 26 February 2004                                    |" + STR_NEWLINE +
                "| Participants:                                                      |" + STR_NEWLINE +
                "|    My user name :) ): (here's some text.) :( :) _- _ ?! qaw :! :() (localhost@hotmail.com)                           |" + STR_NEWLINE +
                "|    nospam@nospam.com (remotehost@hotmail.com)                     |" + STR_NEWLINE +
                ".--------------------------------------------------------------------." + STR_NEWLINE + // 6 lines of header
                "[16:44:33] My user name: Hello there" + STR_NEWLINE +
                "[16:45:02] Recipient's : hi" + STR_NEWLINE +
                "[16:45:49] My user name: How are you?" + STR_NEWLINE +
                "[16:46:37] Recipient's : I'm ok" + STR_NEWLINE +
                "[16:46:38] Recipient's : yourself?" + //STR_NEWLINE +
                "");

        String strInput = null;

        if (args == null || args.length == 0) // No arugment provided
        {
            strInput = STR_SAMPLE_CHATLOG;
        }
        else
        {
            // Argument must be first
            try
            {
                strInput = readTextFile(new File(args[0]));
            }
            catch (Exception ex)
            {
                System.out.println();
                System.out.println("Exception:");
                ex.printStackTrace(System.err);
            }
        }

        // Chatlog has two sections: Header and Content
        String strHeader = ""; // Chatlog header (full String)
        String strContent = ""; // Chatlog content (full String)

        // Create a String array of each line in the chatlog
        String[] strArraySplit = strInput.split("\n");

        // ArrayList holds each line of the chatlog so each line can be processed individually
        ArrayList<String> alistHeader = new ArrayList<String>(); // Chatlog header (one element per line)
        ArrayList<String> alistContent = new ArrayList<String>(); // Chatlog content (one element per line)

        int intNumberOfContacts = 0;

        Contact[] contactsArray = null; // Array to hold instances of the Contact class

        // Patterns and regular expressions
        Pattern patternSessionStartDate = Pattern.compile("(\\d{1,2})[ -]([\\dA-Za-z]+)[ -](\\d{2,4})"); // (?<day>\d{1,2})[ -](?<month>[\dA-Za-z]+)[ -](?<year>\d{2,4})
        Pattern patternTimestamp = Pattern.compile("[0-9]{1,2}:[0-9]{1,2}:[0-9]{1,2}");
        Pattern patternHeaderContactName = Pattern.compile("\\b(.+)(?=.+\\([a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?)");
        Pattern patternHeaderContactEmail = Pattern.compile("(\\()([a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?)(\\))"); // [a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?
        Matcher matcher = null;

        // Source DateFormat
        DateFormat dfDayMonthYear = new SimpleDateFormat("dd MMMMM yyyy");
        DateFormat dfDayMonthYearTime = new SimpleDateFormat("dd MMMMM yyyy HH:mm:ss");
        // Target DateFormat
        DateFormat dfYearMonthDay = new SimpleDateFormat("yyyy-MM-dd");
        DateFormat dfYearMonthDayTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        // DateFormat Timestamp
        DateFormat dfTimestamp = new SimpleDateFormat("HH:mm:ss");
        // Filename
        DateFormat dfFilename = new SimpleDateFormat("yyyy-MM-dd.HHmmss");

        Date dateSessionStart = null; // Full date contains SessionStartDate (from header) and SessionStartTime (from first content line's timestamp)

        // Date and time as String
        String strSessionStartDate = null; // Session start date from header
        String strSessionStartTime = null; // Timestamp from first content line
        
        // Hard-coded values
        final int INT_LINES_IN_HEADER = (getLastHeaderLine(strArraySplit) + 1);
        final int INT_FIRST_CONTACT_LINE = (getFirstHeaderContactLine(strArraySplit));
        final int INT_TIMESTAMP_LENGTH = (getTimestampLength(strArraySplit, INT_LINES_IN_HEADER)); // 11

        // Add chatlog header lines into ArrayList alistHeader and strHeader
        for (int i = 0; i < INT_LINES_IN_HEADER; i++)
        {
            alistHeader.add(strArraySplit[i]);

            // If last line in header, do not add a newline
            strHeader += strArraySplit[i] + (i != (INT_LINES_IN_HEADER - 1) ? STR_NEWLINE : "");
        }

        // Add chatlog content lines into ArrayList alistContent and strContent
        for (int i = INT_LINES_IN_HEADER; i < strArraySplit.length; i++)
        {
            alistContent.add(strArraySplit[i]);

            // If last line in content, do not add a newline
            strContent += strArraySplit[i] + (i != (strArraySplit.length - 1) ? STR_NEWLINE : "");
        }

        printArrayList(alistHeader); // debug

        /* PROCESS HEADER */

        /* Find Session Start date in header */
        matcher = patternSessionStartDate.matcher(alistHeader.get(1));
        if (matcher.find())
        {
            strSessionStartDate = matcher.group(0);
        }
        else
        {
            System.out.println("\"Session Start\" date not found in header.");
        }

        /* Find the number of contacts in header */
        matcher = patternHeaderContactEmail.matcher(strHeader);
        while (matcher.find())
        {
            // Each email match in header represents one Contact
            intNumberOfContacts++;
        }

        println("Number of Contacts: " + intNumberOfContacts); // debug

        /* Store each Contact's name and email into contactsArray */
        contactsArray = new Contact[intNumberOfContacts]; // Create an array with the known number of contacts

        for (int i = 0; i < contactsArray.length; i++)
        {
            contactsArray[i] = new Contact();

            /* Find the contact name */
            matcher = patternHeaderContactName.matcher(alistHeader.get(INT_FIRST_CONTACT_LINE + i));
            if (matcher.find())
            {
                contactsArray[i].setName(matcher.group(0));
            }
            else
            {
                System.out.println("Name not found in header.");
            }

            /* Find the contact email */
            matcher = patternHeaderContactEmail.matcher(alistHeader.get(INT_FIRST_CONTACT_LINE + i));
            if (matcher.find() && matcher.groupCount() == 3)
            {
                // Group 1: "("; Group 2: email@email.com; Group 3: ")"
                contactsArray[i].setEmail(matcher.group(2));
            }
            else
            {
                System.out.println("Email not found in header.");
            }

            /* Print out the contact details */ // debug
            System.out.println("Contact " + (i + 1) + ":");
            System.out.println("\t" + "Name: " + contactsArray[i].getName());
            System.out.println("\t" + "Email: " + contactsArray[i].getEmail());
            System.out.println();
        }

        /* DONE PROCESSING HEADER */

        /* PROCESS CONTENT */

        // Get the first timestamp, and add it to dateSessionStart
        matcher = patternTimestamp.matcher(alistContent.get(0));

        /* Find the first timestamp, and add it to the full date dateSessionStart */
        if (matcher.find())
        {
            strSessionStartTime = matcher.group(0);

            try
            {
                dateSessionStart = dfDayMonthYearTime.parse(strSessionStartDate + " " + strSessionStartTime);
                //System.out.println(dfYearMonthDayTime.format(dateSessionStart)); // debug
            }
            catch (Exception ex)
            {
                System.out.println();
                System.out.println("Exception:");
                ex.printStackTrace(System.err);
            }
        }
        else
        {
            System.out.println("First timestamp not found in chatlog.");
        }

        ArrayList<Date> alistContactTimestamp = new ArrayList<Date>();
        ArrayList<String> alistContactName = new ArrayList<String>();
        ArrayList<String> alistContactMessage = new ArrayList<String>();

        String[] strArrayContent = null; // Used for splitting the "Name: Message"

        String strContactTimestamp = "";

        /* Store contact timestamp, name, and message */
        for (int i = 0; i < alistContent.size(); i++) // For each line in chatlog content
        {
            /* Store contact timestamp */
            matcher = patternTimestamp.matcher(alistContent.get(i));
            if (matcher.find())
            {
                strContactTimestamp = matcher.group(0);

                try
                {
                    Date dateTimestamp = dfTimestamp.parse(strContactTimestamp);

                    alistContactTimestamp.add(dateTimestamp);
                }
                catch (Exception ex)
                {
                    System.out.println();
                    System.out.println("Exception:");
                    ex.printStackTrace(System.err);
                }
            }
            else
            {
                System.out.println("Timestamp not found in chatlog content line " + (i + 1) + ".");
            }

            // Split contact name and message
            strArrayContent = alistContent.get(i).substring(INT_TIMESTAMP_LENGTH).split(": ", 2);

            /* Store contact name */
            alistContactName.add(strArrayContent[0]);

            /* Store contact message */
            alistContactMessage.add(strArrayContent[1]);
        }

        /* DONE PROCESSING CONTENT */
        
        /* PROCESS OUTPUT */

        String strOutput = "";

        strOutput += "<html><head><title>Conversation with " + contactsArray[1].getEmail() + " at " + dfYearMonthDayTime.format(dateSessionStart) + " on " + contactsArray[0].getEmail() + " (msn)</title></head><body><h3>Conversation with " + contactsArray[1].getEmail() + " at " + dfYearMonthDayTime.format(dateSessionStart) + " on " + contactsArray[0].getEmail() + " (msn)</h3>";

        if (alistContactTimestamp.size() == alistContactName.size() && alistContactTimestamp.size() == alistContactMessage.size()) // If contact timestamp, name, and message are all matching
        {
            for (int i = 0; i < alistContactTimestamp.size(); i++)
            {
                strOutput += STR_NEWLINE;

                if (contactsArray[0].getName().startsWith(alistContactName.get(i))) // If the first full contact name starts with this truncated contact name
                {
                    // local user
                    strOutput += "<font color=\"#16569E\"><font size=\"2\">(" + dfTimestamp.format(alistContactTimestamp.get(i)) + ")</font> <b>" + alistContactName.get(i) + ":</b></font> <font sml=\"MSN\">" + alistContactMessage.get(i) + "</font><br/>";
                }
                else
                {
                    strOutput += "<font color=\"#A82F2F\"><font size=\"2\">(" + dfTimestamp.format(alistContactTimestamp.get(i)) + ")</font> <b>" + alistContactName.get(i) + ":</b></font> <font sml=\"MSN\"><span style=\"font-family: High Tower Text;\"><strong><span style=\"color: #ff0000;\">" + alistContactMessage.get(i) + "</span></strong></span></font><br/>";
                }
            }

            strOutput += "</body></html>";
        }
        else
        {
            System.out.println("Contact timestamp, name, and message do not match.");
        }

        /* OUTPUT */
        //System.out.println(strOutput);

        File currentDirectory = null;
        File folderPath = null;

        String strFoldername = contactsArray[1].getEmail();
        String strFilename = dfFilename.format(dateSessionStart) + ".html";

        try
        {
            currentDirectory = new File(".");
            folderPath = new File(currentDirectory.getCanonicalPath() + File.separator + strFoldername);
            
            folderPath.mkdirs();

            writeTextFile(folderPath.getPath() + File.separator + strFilename, strOutput);
        }
        catch (Exception ex)
        {
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);
        }
    }

    /**
     * Retrieve input from the user
     *
     * @return String input from user
     */
    private static String retrieveInput(String strInputText)
    {
        Scanner scannerInput = new Scanner(System.in); // Accept input from user

        System.out.print(strInputText);

        return (scannerInput.nextLine()); // Return input from user
    }

    private static int getLastHeaderLine(String[] strArrayChatlog)
    {
        for (int i = 1; i < strArrayChatlog.length; i++)
        {
            if (strArrayChatlog[i].startsWith(".---------------------------------"))
            {
                return (i);
            }
        }

        return (-1); // Not found
    }

    private static int getFirstHeaderContactLine(String[] strArrayChatlog)
    {
        for (int i = 1; i < strArrayChatlog.length; i++)
        {
            if (strArrayChatlog[i].startsWith("| Participants:"))
            {
                return (i + 1);
            }
        }

        return (-1); // Not found
    }

    private static int getTimestampLength(String[] strArrayChatlog, int intFirstContentLine)
    {
        //Gets the first timestamp length and assumes unchanged
        Pattern patternTimestamp = Pattern.compile("(\\W)([0-9]{1,2}:[0-9]{1,2}:[0-9]{1,2})(\\W\\s)");
        Matcher matcher = patternTimestamp.matcher(strArrayChatlog[intFirstContentLine]);

        if (matcher.find())
        {
            return (matcher.end());
        }
        else
        {
            System.out.println("First timestamp not found in content.");
        }

        return (-1); // Not found
    }

    /**
     * Omit the empty Strings from a String array
     *
     * @param strArray the array for which its empty Strings will be omitted
     * @return the new array without the empty strings
     */
    private static String[] omitEmptyStrings(String[] strArray)
    {
        ArrayList<String> alistTemporary = new ArrayList<String>();

        for (String str : strArray)
        {
            if (!str.equals(""))
            {
                alistTemporary.add(str);
            }
        }

        strArray = new String[0];

        return (alistTemporary.toArray(strArray));
    }

    /**
     * Omit the whitespace from a String array
     *
     * @param strArray the array for which its whitespace will be omitted
     * @return the new array without the whitespace
     */
    private static String[] omitWhitespace(String[] strArray)
    {
        ArrayList<String> alistTemporary = new ArrayList<String>();

        for (String str : strArray)
        {
            if (str.trim().length() != 0)
            {
                alistTemporary.add(str);
            }
        }

        strArray = new String[0];

        return (alistTemporary.toArray(strArray));
    }

    /**
     * Checks if a String is an integer
     *
     * @param strInput the String to be checked
     * @return boolean true if an integer, false if not an integer
     */
    private static boolean isInteger(String strInput)
    {
        try
        {
            Integer.parseInt(strInput); // String is a number if it can be parsed

            return (true);
        }
        catch (NumberFormatException exNumberFormat)
        {
            /*
            // Not a number
            System.out.println();
            System.out.println("You did not enter a number.");

            System.out.println();
            System.out.println("Exception:");
            exNumberFormat.printStackTrace(System.err);
            */

            return (false);
        }
        catch (Exception ex)
        {
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);

            return (false);
        }
    }

    /**
     * Checks if a String is a number
     *
     * @param strInput the String to be checked
     * @return boolean true if a number, false if not a number
     */
    private static boolean isNumber(String strInput)
    {
        try
        {
            Double.parseDouble(strInput); // String is a number if it can be parsed

            return (true);
        }
        catch (NumberFormatException exNumberFormat)
        {
            /*
            // Not a number
            System.out.println();
            System.out.println("You did not enter a number.");

            System.out.println();
            System.out.println("Exception:");
            exNumberFormat.printStackTrace(System.err);
            */

            return (false);
        }
        catch (Exception ex)
        {
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);

            return (false);
        }
    }

    /**
     * Prints an object's toString() value to the screen as a String using System.out.print(),
     * Used for debugging and easy value tracking
     *
     * @param objPrint the object to be printed
     */
    private static void print(Object objPrint)
    {
        System.out.print(objPrint.toString());
    }

    /**
     * Prints an object's toString() value to the screen as a String with an extra line using System.out.println(),
     * Used for debugging and easy value tracking
     *
     * @param objPrint the object to be printed
     */
    private static void println(Object objPrint)
    {
        System.out.println(objPrint.toString());
    }

    /**
     * Prints out each object in the object array parameter to screen as a String using System.out.println(),
     * Used for debugging and value tracking
     *
     * @param objArray object array to be printed
     */
    private static void printArray(Object[] objArray)
    {
        for (Object obj : objArray)
        {
            System.out.println(obj.toString());
        }
    }

    /**
     * Prints out each object in the ArrayList parameter to screen as a String using System.out.println(),
     * Used for debugging and value tracking
     *
     * @param alistArray ArrayList to be printed
     */
    private static void printArrayList(ArrayList alistArray)
    {
        for (Object obj : alistArray)
        {
            System.out.println(obj.toString());
        }
    }

    /**
     * Reads in a text file
     *
     * @param file
     * @return
     * @throws Exception
     */
    private static String readTextFile(File file) throws Exception
    {
        Scanner scanner = null;

        String strFileContent = "";

        try
        {
            scanner = new Scanner(file, "UTF-8");

            while (scanner.hasNextLine())
            {
                strFileContent += (scanner.nextLine() + STR_NEWLINE);
            }
        }
        catch (IOException exIO)
        {
            // Access error
            System.out.println();
            System.out.println("Exception:");
            exIO.printStackTrace(System.err);
        }
        catch (Exception ex)
        {
            // Something happened
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);
        }
        finally
        {
            try
            {
                scanner.close();
            }
            catch (Exception ex)
            {
                // Failed to close the file
                System.out.println();
                System.out.println("Exception:");
                ex.printStackTrace(System.err);
            }
        }

        return (strFileContent);
    }

    /**
     * Writes a String to a new text file with a unique date and time in the filename
     * 
     * @param strFilename
     * @param strFileContent
     */
    private static void writeTextFile(String strFilename, String strFileContent)
    {
        // Date and Time
        //DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd.HHmmss");
        //Date currentDateTime = new Date();

        Writer writerTextFile = null;

        try
        {
            writerTextFile = new OutputStreamWriter(new FileOutputStream(strFilename), "UTF-8");

            writerTextFile.write(strFileContent);
        }
        catch (IOException exIO)
        {
            // Access error
            System.out.println();
            System.out.println("Exception:");
            exIO.printStackTrace(System.err);
        }
        catch (Exception ex)
        {
            // Something happened
            System.out.println();
            System.out.println("Exception:");
            ex.printStackTrace(System.err);
        }
        finally
        {
            try
            {
                writerTextFile.close();
            }
            catch (Exception ex)
            {
                // Failed to close the file
                System.out.println();
                System.out.println("Exception:");
                ex.printStackTrace(System.err);
            }
        }
    }
}